<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use App\Http\Controllers\SubscriptionController;

class Kernel extends ConsoleKernel
{
    protected function schedule(Schedule $schedule)
    {
        $schedule->command('jobs:close-expired')->daily();
        $schedule->command('course:progress')->everyMinute();
        $schedule->call([SubscriptionController::class, 'checkAndDeactivateSubscriptions'])->dailyAt('00:00'); // Deactivate expired subscriptions daily
    }

    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
